'From Squeak3.5 of ''11 April 2003'' [latest update: #5180] on 6 February 2004 at 5:04:41 pm'!
Morph subclass: #BowlingFrameMorph
	instanceVariableNames: 'score pins numBalls basePoint '
	classVariableNames: 'FrameHeight FrameWidth '
	poolDictionaries: ''
	category: 'My Stuff'!

!BowlingFrameMorph methodsFor: 'initialization' stamp: 'DY 2/4/2004 14:03'!
initialize: twoOrThree at: aPoint
	super initialize.
	numBalls _ twoOrThree.
	pins _ Array new: numBalls.
	basePoint _ aPoint.
	self changed.! !


!BowlingFrameMorph methodsFor: 'modifying' stamp: 'DY 2/4/2004 19:56'!
moveTo: newBasePoint 
	basePoint _ newBasePoint.
	self changed! !

!BowlingFrameMorph methodsFor: 'modifying' stamp: 'DY 2/4/2004 11:37'!
setPinCount: anInteger to: aCount 
	pins at: anInteger put: aCount.
	self changed! !

!BowlingFrameMorph methodsFor: 'modifying' stamp: 'DY 2/4/2004 22:00'!
setScore: anInteger 
	score _ anInteger.
	self changed! !


!BowlingFrameMorph methodsFor: 'drawing' stamp: 'DY 2/4/2004 19:52'!
drawOn: aCanvas
	|upper lower right left rect digitWidth digitHeight|
	upper _ basePoint y.
	lower _ basePoint y + 40.
	left _ basePoint x.
	right _ basePoint x + FrameWidth.
	digitWidth _ 12.
	digitHeight _ 19.
	rect := Rectangle left: left right: right top: upper bottom: lower.
	self bounds: rect.
	aCanvas frameRectangle: self bounds color: Color black.
	score ifNotNil: [
		aCanvas drawString: score printString at: (left+15)@(upper+25).
	].
	rect := Rectangle left: right-(numBalls*digitWidth)-1 right: right-((numBalls-1)*digitWidth)
		 top: upper bottom: upper+digitHeight.
	aCanvas frameRectangle: rect color: Color black.
	(pins at: 1) ifNotNil: [
		(pins at: 1) = 10 ifTrue: [
			aCanvas line: rect topLeft to: rect bottomRight color: Color black.
			aCanvas line: rect topRight to: rect bottomLeft color: Color black.
		]
		ifFalse: [
			aCanvas drawString: (pins at: 1) printString at: (right-(numBalls*digitWidth)+3)@(upper+5)
		]
	].
	rect := Rectangle left: rect left + digitWidth right: rect right+digitWidth 
					 top: rect top bottom: rect bottom.
	aCanvas frameRectangle: rect color: Color black.
	(pins at: 2) ifNotNil: [
		(pins at: 1) = 10 & ((pins at: 2) = 10) ifTrue: [
			aCanvas line: rect topLeft to: rect bottomRight color: Color black.
			aCanvas line: rect topRight to: rect bottomLeft color: Color black.
		]
		ifFalse: [
			(pins at: 1) + (pins at: 2) = 10 ifTrue: [
				aCanvas line: rect topRight to: rect bottomLeft color: Color black.
			]
			ifFalse: [
				aCanvas drawString: (pins at: 2) printString at: (right-((numBalls-1)*digitWidth)+3)@(upper+5)
			]
		]
	].
	numBalls = 3 ifTrue: [
		rect := Rectangle left: rect left + digitWidth right: rect right+digitWidth top: rect top bottom: rect bottom.
		aCanvas frameRectangle: rect color: Color black.
	].
	(numBalls = 3 and: [(pins at: 3) ~~ nil ]) ifTrue: [
		(pins at: 3) = 10 & ((pins at: 1) + (pins at: 2) \\ 10 == 0) ifTrue: [
			aCanvas line: rect topLeft to: rect bottomRight color: Color black.
			aCanvas line: rect topRight to: rect bottomLeft color: Color black.
		]
		ifFalse: [
			((pins at: 1) = 10 and: [(pins at: 2) + (pins at: 3) = 10 ]) ifTrue: [
				aCanvas line: rect topRight to: rect bottomLeft color: Color black
			]
			ifFalse: [
				aCanvas drawString: (pins at: 3) printString at: (right-digitWidth+3)@(upper+5)			
			]
		]
	].
		

! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

BowlingFrameMorph class
	instanceVariableNames: ''!

!BowlingFrameMorph class methodsFor: 'class initialization' stamp: 'DY 2/4/2004 18:50'!
initialize
	FrameWidth := 50.
	FrameHeight := 40.! !


!BowlingFrameMorph class methodsFor: 'instance creation' stamp: 'DY 2/4/2004 21:43'!
new: twoOrThree at: aPoint
	^super new initialize: twoOrThree at: aPoint.

	! !


!BowlingFrameMorph class methodsFor: 'accessing' stamp: 'DY 2/4/2004 18:23'!
height
^FrameHeight! !

!BowlingFrameMorph class methodsFor: 'accessing' stamp: 'DY 2/4/2004 18:17'!
width

^FrameWidth! !


BowlingFrameMorph initialize!
